/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.devices;

/**
 * Class to implement the sample node for the buffer queue.
 */
class SampleNode
{
	byte [] bData;
	int iSequenceNumber;
	long lPacketRecordTime;
	boolean bIsSilence;
	boolean bPriorDataSequenceComplete;
	SampleNode later;
	SampleNode earlier;

	/**
	 * Constructor for the sample node.
	 * @param bData the byte array of the packet to be store in the node
	 * @param iSequenceNumber the sequence number of the packet being stored
	 * @param lPacketRecordTime the record time for the packet
	 */
	public SampleNode(byte [] bData, int iSequenceNumber, long lPacketRecordTime)
	{
		bIsSilence = false;
		this.bData = bData;
		this.iSequenceNumber = iSequenceNumber;
		this.lPacketRecordTime = lPacketRecordTime;
		later = null;
		earlier = null;
		bPriorDataSequenceComplete = false;
	}

	/**
	 * Constructor for the sample node.
	 * @param bData the byte array of the packet to be store in the node
	 * @param iSequenceNumber the sequence number of the packet being stored
	 * @param lPacketRecordTime the record time for the packet
	 * @param bIsSilence true if this is a silence packet
	 */
	public SampleNode(byte [] bData, int iSequenceNumber, long lPacketRecordTime, boolean bIsSilence)
	{
		bIsSilence = bIsSilence;
		this.bData = bData;
		this.iSequenceNumber = iSequenceNumber;
		this.lPacketRecordTime = lPacketRecordTime;
		this.bIsSilence = bIsSilence;
		later = null;
		earlier = null;
		bPriorDataSequenceComplete = false;
	}
}
